<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>TETEDMARKET</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;600;700&display=swap" rel="stylesheet">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:'Poppins',sans-serif;}
body{background:#000;color:#fff;overflow-x:hidden;}
canvas{position:fixed;top:0;left:0;z-index:-1;}

header{
text-align:center;
padding:20px;
font-weight:700;
font-size:20px;
background:rgba(0,0,0,0.6);
backdrop-filter:blur(20px);
border-bottom:1px solid rgba(0,255,255,0.3);
box-shadow:0 0 25px rgba(0,255,255,0.2);
}

.title{text-align:center;margin:30px 0;font-size:26px;font-weight:700;}

.container{
display:grid;
grid-template-columns:repeat(auto-fit,minmax(250px,1fr));
gap:20px;
padding:20px;
}

.card{
background:rgba(255,255,255,0.05);
border-radius:20px;
padding:25px;
text-align:center;
backdrop-filter:blur(25px);
border:1px solid rgba(0,255,255,0.3);
box-shadow:0 0 25px rgba(0,255,255,0.25);
transition:0.4s;
}

.card:hover{
transform:translateY(-8px);
box-shadow:0 0 45px rgba(0,255,255,0.6);
}

.price{color:#00ffff;font-weight:700;margin:10px 0;font-size:18px;}

.btn{
background:linear-gradient(45deg,#00ffff,#0099ff);
padding:10px 20px;
border-radius:30px;
color:#000;
font-weight:700;
display:inline-block;
margin-top:15px;
cursor:pointer;
transition:0.3s;
}

.btn:hover{opacity:0.8;}

.popup{
display:none;
position:fixed;
top:0;
left:0;
width:100%;
height:100%;
background:rgba(0,0,0,0.85);
justify-content:center;
align-items:center;
padding:20px;
}

.popup-content{
background:#111;
padding:25px;
border-radius:20px;
text-align:center;
border:1px solid rgba(0,255,255,0.4);
box-shadow:0 0 35px rgba(0,255,255,0.4);
max-width:350px;
width:100%;
}

.popup img{width:200px;margin:10px 0;border-radius:10px;}

.close{margin-top:15px;color:red;cursor:pointer;font-size:14px;}

footer{text-align:center;padding:20px;opacity:0.6;font-size:12px;}
</style>
</head>
<body>

<canvas id="galaxy"></canvas>

<header>🛒 TETEDMARKET</header>

<div class="title">Open All Produk🔥</div>

<div class="container">

<div class="card">
<h3>Murvda</h3>
<div class="price">Rp 30.000</div>
<p>Benefit: Free Impulse 🚀</p>
<div class="btn" onclick="openPopup('Murvda - 30K')">Beli Sekarang</div>
</div>

<div class="card">
<h3>Nebeng Impulse</h3>
<div class="price">Rp 20.000</div>
<p>Akses Nebeng Impulse</p>
<div class="btn" onclick="openPopup('Nebeng Impulse - 20K')">Beli Sekarang</div>
</div>

<div class="card">
<h3>Open Marga Jasteb</h3>
<div class="price">Rp 30.000</div>
<p>Full Akses + VIP</p>
<div class="btn" onclick="openPopup('Open Marga Jasteb - 30K')">Beli Sekarang</div>
</div>

<div class="card">
<h3>Open PT Jasteb</h3>
<div class="price">Rp 15.000</div>
<p>Benefit PM Admin</p>
<div class="btn" onclick="openPopup('Open PT Jasteb - 15K')">Beli Sekarang</div>
</div>

<div class="card">
<h3>Founder</h3>
<div class="price">Rp 100.000</div>
<p>Akses Founder + Benefit Full</p>
<div class="btn" onclick="openPopup('Founder - 100K')">Beli Sekarang</div>
</div>

<div class="card">
<h3>Jasteb</h3>
<div class="price">Rp 5.000</div>
<p>Ress No Ampas</p>
<div class="btn" onclick="openPopup('Jasteb - 5K')">Beli Sekarang</div>
</div>

</div>

<footer>© 2026 TetedMarket — Galaxy Edition</footer>

<div class="popup" id="popup">
<div class="popup-content">

<h3>Pembayaran QRIS / DANA / GoPay</h3>

<img src="QRIS.png" alt="QRIS">

<h4>Upload Bukti Pembayaran</h4>
<input type="file" id="bukti" accept="image/*">
<br>
<img id="preview" style="display:none;width:200px;border-radius:10px;margin-top:10px;">
<br><br>
<div class="btn" onclick="kirimBukti()">Kirim ke Admin</div>

<div class="close" onclick="closePopup()">Tutup</div>

</div>
</div>

<script>
let selectedProduct = "";
const nomorAdmin = "6285860378462";

function openPopup(product){
selectedProduct = product;
document.getElementById("popup").style.display="flex";
}

function closePopup(){
document.getElementById("popup").style.display="none";
}

const fileInput = document.getElementById("bukti");
const preview = document.getElementById("preview");

fileInput.addEventListener("change", function(){
const file = this.files[0];
if(file){
const reader = new FileReader();
reader.onload = function(e){
preview.src = e.target.result;
preview.style.display = "block";
}
reader.readAsDataURL(file);
}
});

function kirimBukti(){
if(!fileInput.files[0]){
alert("Upload bukti dulu bro!");
return;
}

let pesan = `Halo Admin 👋
Saya sudah transfer untuk:
${selectedProduct}

Metode: QRIS/DANA/GoPay
Bukti akan saya kirim di chat ini.`;

window.location.href = "https://wa.me/+6285860378462"+nomorAdmin+"?text="+encodeURIComponent(pesan);
}

const canvas = document.getElementById("galaxy");
const ctx = canvas.getContext("2d");
canvas.width = window.innerWidth;
canvas.height = window.innerHeight;

let stars=[];
for(let i=0;i<150;i++){
stars.push({
x:Math.random()*canvas.width,
y:Math.random()*canvas.height,
radius:Math.random()*1.5,
speed:Math.random()*0.5
});
}

function draw(){
ctx.clearRect(0,0,canvas.width,canvas.height);
ctx.fillStyle="white";
stars.forEach(star=>{
ctx.beginPath();
ctx.arc(star.x,star.y,star.radius,0,Math.PI*2);
ctx.fill();
star.y+=star.speed;
if(star.y>canvas.height) star.y=0;
});
requestAnimationFrame(draw);
}
draw();
</script>

</body>
</html>